<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Session;
use App\Models\User;
use App\Models\AdminUsers;
use Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Mail;

class AuthController extends Controller
{
    public function login(){
        if (!Auth::guard('admin')->check()) {
            return view('auth.login');
        } else {
            if (Auth::guard('admin')->check()) {
                return redirect('admin/dashboard');
            }
        }
    }

    public function postLogin(Request $request){
        try {
            extract($request->Input());
            if (!empty($email) && !empty($password)) {
                $user = AdminUsers::where('email', $email)->first();
                if (!empty($user)) {
                    if (Hash::check($password, $user->password)) {
                        $user = AdminUsers::find($user->id);
                        Auth::guard('web')->login($user);
                        $status = 200;
                        $message = __('messages.LOGIN_SUCCESS');
                    } else {
                        $status = 400;
                        $message = __('messages.PASSWORD_INCORRECT');
                    }
                } else {
                    $status = 400;
                    $message = __('messages.INCORRECT_EMAIL');
                }
            } else {
                $status = 400;
                $message = __('messages.INVALID_CREDS');
            }
        } catch (\Exception $e) {
            $status = 400;
            $message = __('messages.SOMETHING_WRONG');
        }
        return response()->json(
            [
                'message' => $message,
            ],
            $status,
        );
    }
    public function logout(){
        if (Auth::user()) {
            Session::flush();
            Auth::logout();
        }
        return Redirect::to('/');
    }
   
}
