<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('contracting_business', function (Blueprint $table) {
            $table->text('tagLine')->after('updated_at')->nullable(false);
            $table->string('business_image', 255)->after('tagLine')->nullable(false);
        });
    }

    public function down()
    {
        Schema::table('contracting_business', function (Blueprint $table) {
            $table->dropColumn(['tagLine', 'business_image']);
        });
    }
};
