<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <title>Bensin</title>
    <link rel="icon" href="{!! asset('images/logo.png') !!}" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" type="text/css" media="screen" href="{!! asset('css/bootstrap.min.css') !!}">
    <link rel="stylesheet" type="text/css" media="screen" href="{!! asset('css/login.css') !!}">
    <script type="text/javascript" src="{!! asset('js/jquery.min.js') !!}"></script>
</head>

<body>
    <div class="login-form">
        
        <main class="form-signin">
            <div class="login-main">
                <div class="forgot-pass-wrap">
                    @if (Session::has('failure'))
                        <p class="alert-danger text-danger">{{ Session::get('failure') }}</p>
                    @endif
                    @if (Session::has('success'))
                        <p class="alert-success text-success">{{ Session::get('success') }}</p>
                    @endif
                    <p class="alert-danger text-danger" style="display:none;"></p>
                </div>
                <form class="from_wrapp" id="loginForm" method="post">
                    @csrf
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" class="form-control removeSameValueAndSpace required"
                            placeholder="Enter Email" name="email">
                    </div>
                    <div class="form-group">
                        <label>Password</label>
                        <input type="password" class="form-control removeSameValueAndSpace required"
                            placeholder="Enter Password" name="password">
                    </div>
                    <div class="login-button">
                        <button class="login-btn" type="submit">Log in</button>
                    </div>
                </form>
            </div>
        </main>
    </div>
    <script type="text/javascript" src="{{ asset('js/jquery.validate.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/bootstrap.min.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script type="text/javascript" src="{{ asset('js/bootstrap.bundle.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/custom.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('.alert-danger').delay(5000).fadeOut();
            $('.alert-success').delay(5000).fadeOut();
            localStorage.removeItem('email');
            jQuery.validator.addMethod("email", function(value, element) {
                return this.optional(element) ||
                    /^([a-zA-Z0-9_.+-])+@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/.test(value);
            }, "Please enter a valid email address.");

            $('#loginForm').validate({
                rules: {
                    email: {
                        required: true,
                        email: true
                    },
                    password: {
                        required: true,
                        minlength: 8
                    }
                },
                messages: {
                    email: {
                        required: "Please enter your email",
                        email: "Please enter a valid email address"
                    },
                    password: {
                        required: "Please enter your password",
                        minlength: "Your password must be at least 8 characters long"
                    }
                },
                submitHandler: function(form) {
                    $('body').prepend('<div class="loader"></div>');
                    loginSubmit();
                }
            });
        });

        function loginSubmit() {
            $("button[type=submit]").attr("disabled", "disabled");
            var formData = new FormData($('#loginForm')[0]);
            $.ajax({
                url: "{{ url('postLogin') }}",
                type: 'POST',
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    $('.loader').remove();
                    $("button[type=submit]").removeAttr('disabled');
                    window.location.href = "{{ url('admin/dashboard') }}";
                },
                error: function(error) {
                    $('.loader').remove();
                    $('html, body').animate({
                        scrollTop: $('body').offset().top
                    }, 300);
                    $("button[type=submit]").removeAttr('disabled');
                    $('.alert-danger').text(error.responseJSON.message).show().delay(5000).fadeOut();
                },
            });
        }

        function redirectForgotPassword() {
            window.location.href = "{{ url('forgot-password') }}";
        }
    </script>
</body>

</html>
