@extends('layouts.master')
@section('title', 'Station : List')
@section('content')
    <div class="middle-part-wrap location-list-page-wrap list_view">
        <div class="leadership-list-wrap location-list-wrap">
            <div class="leadership-top-header">
                <h3>Stations</h3>
            </div>
            <div class="leadership-list-data scroll">
                <ul class="listRecordsUl">
                    <div class="card">
                        <div class="card-body">
                            <table id="list" class="table table-striped table-bordered viewdatatable dt-responsive nowrap" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Name</th>
                                        <th>Company</th>
                                        <th>Address</th>
                                        <th>Latitude</th>
                                        <th>Longitude</th>
                                        <th>Last Updated</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </ul>
            </div>
        </div>
    </div>

    <div class="middle-part-wrap location-list-page-wrap details_view" style="display:none">
        <div class="leadership-list-wrap location-list-wrap">
            <div class="leadership-top-header">
                <h3>Stations Details</h3>
                <a href="javascript::void()" class="backBtn common-btn">Back</a>
            </div>
            <div class="leadership-list-data scroll">
                <ul class="listRecordsUl">
                    <div class="card">
                        <div class="card-body">
                            <div class="container">
                                <form class="needs-validation" id="stationForm" novalidate>
                                    @csrf
                                    <input type="hidden" name="station_id" value="">
                                    <input type="hidden" name="request_id" value="">
                                    <div class="row">
                                        <div class="col-md-12 order-md-1">
                                            <div class="row">
                                                <div class="col-md-6 mb-3">
                                                    <label for="name"><strong>Name : </strong></label>
                                                    <span name="name"></span>
                                                </div>
                                                <div class="col-md-6 mb-3">
                                                    <label for="company"><strong>Company : </strong></label>
                                                    <span name="company"></span>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 mb-3">
                                                    <label for="latitude"><strong>Latitude : </strong></label>
                                                    <span name="latitude"></span>
                                                </div>
                                                <div class="col-md-6 mb-3">
                                                    <label for="longitude"><strong>Longitude : </strong></label>
                                                    <span name="longitude"></span>
                                                </div>
                                            </div>
                                            <div class="mb-3">
                                                <label for="address"><strong>Adresse : </strong></label>
                                                <span name="address"></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row other_details">
                                        <!-- <div class="d-flex align-items-center mb-3 gap-4">
                                            <label for="dognapent" class="mr-2">Døgnåpent</label>
                                            <div class="dognapent-switch">
                                                <input type="checkbox" id="toggle" class="toggleCheckbox" name="dognapent" />
                                                <label for="toggle" class='toggleContainer'>
                                                    <div>Yes</div>
                                                    <div>No</div>
                                                </label>
                                            </div>
                                        </div> -->
                                        <div class="d-flex align-items-center mb-3 gap-4">
                                            <label for="dognapent" class="mr-2"><strong>Døgnåpent : </strong></label>
                                            <div class="dognapent-switch">
                                                <p class="mb-0" name="dognapent">Yes</p>
                                            </div>
                                        </div>
                                        <div class="col-md-6 order-md-2 mb-4">
                                            <div class="week-day week-day-list">
                                                <ul class="list-group mb-3">
                                                    <li class="list-group-item d-flex align-items-center gap-4 lh-condensed custom-time">
                                                        <div class="week-day-name">
                                                            <h6 class="my-0"><strong>Days</strong></h6>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <h6 class="mb-0"><strong>Start Time</strong></h6>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <h6 class="mb-0"><strong>End Time</strong></h6>
                                                        </div>
                                                    </li>
                                                    <li class="list-group-item d-flex align-items-center gap-4 lh-condensed fully-time">
                                                        <div class="week-day-name">
                                                            <h6 class="my-0"><strong>Days</strong></h6>
                                                        </div>
                                                        <label class="hour_text_lable p-0">24 Hours</label>
                                                    </li>
                                                    <li class="list-group-item d-flex align-items-center gap-4 lh-condensed">
                                                        <div class="week-day-name">
                                                            <h6 class="my-0"><strong>Mandag : </strong></h6>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <span name="startMonday"></span>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <span name="endMonday"></span>
                                                        </div>
                                                        <label class="hour_text_lable p-0">24 Hours</label>
                                                    </li>
                                                    <li class="list-group-item d-flex align-items-center gap-4 lh-condensed">
                                                        <div class="week-day-name">
                                                            <h6 class="my-0"><strong>Tirsdag : </strong></h6>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <span name="startTuesday"></span>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <span name="endTuesday"></span>
                                                        </div>
                                                        <label class="hour_text_lable p-0">24 Hours</label>
                                                    </li>
                                                    <li class="list-group-item d-flex align-items-center gap-4 lh-condensed">
                                                        <div class="week-day-name">
                                                            <h6 class="my-0"><strong>Onsdag : </strong></h6>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <span name="startWednesday"></span>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <span name="endWednesday"></span>
                                                        </div>
                                                        <label class="hour_text_lable p-0">24 Hours</label>
                                                    </li>
                                                    <li class="list-group-item d-flex align-items-center gap-4 lh-condensed">
                                                        <div class="week-day-name">
                                                            <h6 class="my-0"><strong>Torsdag : </strong></h6>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <span name="startThursday"></span>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <span name="endThursday"></span>
                                                        </div>
                                                        <label class="hour_text_lable p-0">24 Hours</label>
                                                    </li>
                                                    <li class="list-group-item d-flex align-items-center gap-4 lh-condensed">
                                                        <div class="week-day-name">
                                                            <h6 class="my-0"><strong>Fredag : </strong></h6>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <span name="startFriday"></span>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <span name="endFriday"></span>
                                                        </div>
                                                        <label class="hour_text_lable p-0">24 Hours</label>
                                                    </li>
                                                    <li class="list-group-item d-flex align-items-center gap-4 lh-condensed">
                                                        <div class="week-day-name">
                                                            <h6 class="my-0"><strong>Lørdag : </strong></h6>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <span name="startSaturday"></span>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <span name="endSaturday"></span>
                                                        </div>
                                                        <label class="hour_text_lable p-0">24 Hours</label>
                                                    </li>
                                                    <li class="list-group-item d-flex align-items-center gap-4 lh-condensed">
                                                        <div class="week-day-name">
                                                            <h6 class="my-0"><strong>Søndag : </strong></h6>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <span name="startSunday"></span>
                                                        </div>
                                                        <div class="start-day-time mb-0">
                                                            <span name="endSunday"></span>
                                                        </div>
                                                        <label class="hour_text_lable p-0">24 Hours</label>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="col-md-6 order-md-2 mb-4">
                                            <div class="station-services station-service-list">
                                                <ul class="list-group mb-3">
                                                    <li class="list-group-item lh-condensed">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div class="service-title d-flex align-items-center">
                                                                <div class="service-icon">
                                                                    <img src="{{ asset('images/InfoToalet.png') }}">
                                                                </div>
                                                                <label for="Kundetoaletter" class="mr-2"><strong>Kundetoaletter</strong></label>
                                                            </div>
                                                            <span name="Kundetoaletter"></span>
                                                        </div>
                                                    </li>
                                                    <li class="list-group-item lh-condensed">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div class="service-title d-flex align-items-center">
                                                                <div class="service-icon">
                                                                    <img src="{{ asset('images/InfoHandi.png') }}">
                                                                </div>
                                                                <label for="Handikaptoalett" class="mr-2"><strong>Handikaptoalett</strong></label>
                                                            </div>
                                                            <span name="Handikaptoalett"></span>
                                                        </div>
                                                    </li>
                                                    <li class="list-group-item lh-condensed">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div class="service-title d-flex align-items-center">
                                                                <div class="service-icon">
                                                                    <img src="{{ asset('images/InfoMaskin.png') }}">
                                                                </div>
                                                                <label for="Bilvask_Maskin" class="mr-2"><strong>Bilvask(Maskin)</strong></label>
                                                            </div>
                                                            <span name="Bilvask_Maskin"></span>
                                                        </div>
                                                    </li>
                                                    <li class="list-group-item lh-condensed">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div class="service-title d-flex align-items-center">
                                                                <div class="service-icon">
                                                                    <img src="{{ asset('images/InfoSelvask.png') }}">
                                                                </div>
                                                                <label for="Bilvask_Selvvask" class="mr-2"><strong>Bilvask(Selvvask)</strong></label>
                                                            </div>
                                                            <span name="Bilvask_Selvvask"></span>
                                                        </div>
                                                    </li>
                                                    <li class="list-group-item lh-condensed">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div class="service-title d-flex align-items-center">
                                                                <div class="service-icon">
                                                                    <img src="{{ asset('images/InfoGass-1.png') }}">
                                                                </div>
                                                                <label for="Gass" class="mr-2"><strong>Gass</strong></label>
                                                            </div>
                                                            <span name="Gass"></span>
                                                        </div>
                                                    </li>
                                                    <li class="list-group-item lh-condensed">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div class="service-title d-flex align-items-center">
                                                                <div class="service-icon">
                                                                    <img src="{{ asset('images/InfoEliectric.png') }}">
                                                                </div>
                                                                <label for="Landestasjoner" class="mr-2"><strong>Landestasjoner</strong></label>
                                                            </div>
                                                            <span name="Landestasjoner"></span>
                                                        </div>
                                                    </li>
                                                    <li class="list-group-item lh-condensed">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div class="service-title d-flex align-items-center">
                                                                <div class="service-icon">
                                                                    <img src="{{ asset('images/InfoTilheng.png') }}">
                                                                </div>
                                                                <label for="Tilhengerleie" class="mr-2"><strong>Tilhengerleie</strong></label>
                                                            </div>
                                                            <span name="Tilhengerleie"></span>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </ul>
            </div>
        </div>
    </div>
    <link rel="stylesheet" type="text/css" media="screen" href="{!! asset('plugin/datatable/dataTables.bootstrap5.css') !!}">
    <script type="text/javascript" src="{!! asset('plugin/datatable/dataTables.js') !!}"></script>
    <script type="text/javascript" src="{!! asset('plugin/datatable/dataTables.bootstrap5.js') !!}"></script>
    <script>

    $(document).ready(function () {
        $(".alert-success, .alert-danger").delay(5000).fadeOut();     
        $('#stationClass').addClass('active'); 
        fill_datatable();
    });
   
    function fill_datatable(){
      var table = $('#list').DataTable({
            scrollX: true,
            lengthMenu: [
                [10, 25, 50],
                [10, 25, 50],
            ],
            "order": [[1, "desc"]],
            "columnDefs": [
                  {
                        "targets": [],
                        "visible": false,
                        "searchable": false
                    },
                {
                    "targets": [],
                    "searchable": false
                }
            ],
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{url('admin/station/getList')}}",
                "dataType": "json",
                "type": "POST",
                "data": {'_token': "{{csrf_token()}}"}
            },
            "columns": [
                {"data": "id", "sortable": false},
                {"data": "name", "className": "text-center"},
                {"data": "company", "className": "text-center"},
                {"data": "address",  "className": "text-center"},
                {"data": "latitude"},
                {"data": "longitude", "className": "text-center"},
                {"data": "lastupdated"},
                {"data": "action", "sortable": false, "className": "text-center"}
            ],
      });
    }
    $(document).on('click', '.show-details', function(){
        var details = JSON.parse($(this).attr('data-details'));
        var id = $(this).attr('data-id');
        $('.list_view').hide();
        $('.details_view').show();
        if(details.name){
            $("span[name=name]").text(details.name);
        }
        if(details.company){
            $("span[name=company]").text(details.company);
        }
        if(details.address){
            $("span[name=address]").text(details.address);
        }
        if(details.latitude){
            $("span[name=latitude]").text(details.latitude);
        }
        if(details.longitude){
            $("span[name=longitude]").text(details.longitude);
        }
        if(details.station_id){
            $("span[name=station_id]").text(details.station_id);
        }
        
        if(details.info){
            $('.other_details').show();
            var info = JSON.parse(details.info)
            if(info.Døgnåpent){
                $(".week-day ul li .start-day-time").attr("style", "display: none !important;");
                $('.list-group-item label.hour_text_lable').show();
                $(".custom-time").attr("style", "display: none !important;");
                $(".fully-time").attr("style", "display: flex !important;");
                $("p[name=dognapent]").text("Yes");
            }else{
                $('.list-group-item label.hour_text_lable').hide();
                $(".week-day ul li .start-day-time").attr("style", "display: flex !important;");
                $(".fully-time").attr("style", "display: none !important;");
                $(".custom-time").attr("style", "display: flex !important;");
                $("p[name=dognapent]").text("No");
            }
            if(info.Kundetoaletter){
                $("span[name=Kundetoaletter]").text("Yes");
            }else{
                $("span[name=Kundetoaletter]").text("No");
            }
            if(info.Handikaptoalett){
                $("span[name=Handikaptoalett]").text("Yes");
            }else{
                $("span[name=Handikaptoalett]").text("No");
            }
            if(info.Gass){
                $("span[name=Gass]").text("Yes");
            }else{
                $("span[name=Gass]").text("No");
            }
            if(info.Tilhengerleie){
                $("span[name=Tilhengerleie]").text("Yes");
            }else{
                $("span[name=Tilhengerleie]").text("No");
            }
            if(info.Landestasjoner){
                $("span[name=Landestasjoner]").text("Yes");
            }else{
                $("span[name=Landestasjoner]").text("No");
            }
            if (info["Bilvask (maskin)"] === true) {
                $("span[name=Bilvask_Maskin]").text("Yes");
            }else{
                $("span[name=Bilvask_Maskin]").text("No");
            }
            if (info["Bilvask (selvvask)"] === true) {
                $("span[name=Bilvask_Selvvask]").text("Yes");
            }else{
                $("span[name=Bilvask_Selvvask]").text("No");
            }
            if (info.Hours) {
                // Loop over each day of the week and set the corresponding start and end times
                for (let day in info.Hours) {
                    if (info.Hours.hasOwnProperty(day)) {
                        let timeRange = info.Hours[day];
                        let times = timeRange.split('-');
                        let startTime = times[0];
                        let endTime = times[1];
                        switch (day) {
                            case "Mandag":
                                $("span[name=startMonday]").text(startTime);
                                $("span[name=endMonday]").text(endTime);
                                break;
                            case "Tirsdag":
                                $("span[name=startTuesday]").text(startTime);
                                $("span[name=endTuesday]").text(endTime);
                                break;
                            case "Onsdag":
                                $("span[name=startWednesday]").text(startTime);
                                $("span[name=endWednesday]").text(endTime);
                                break;
                            case "Torsdag":
                                $("span[name=startThursday]").text(startTime);
                                $("span[name=endThursday]").text(endTime);
                                break;
                            case "Fredag":
                                $("span[name=startFriday]").text(startTime);
                                $("span[name=endFriday]").text(endTime);
                                break;
                            case "Lørdag":
                                $("span[name=startSaturday]").text(startTime);
                                $("span[name=endSaturday]").text(endTime);
                                break;
                            case "Søndag":
                                $("span[name=startSunday]").text(startTime);
                                $("span[name=endSunday]").text(endTime);
                                break;
                            default:
                                break;
                        }
                    }
                }
            }
        }else{
           $('.other_details').hide();
        }
    });
     $(document).on('click', '.backBtn', function(){
        $("#stationForm")[0].reset();
        $('.details_view').hide();
        $('.list_view').show();
    });
    </script>
@stop