<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Middleware\checkAdminRole;
use App\Http\Controllers\{
    AuthController,
    StationController
};

Route::get('/{path?}', [
    'as' => 'login',
    function ($path = null) {
        if (!Auth::guard('web')->check()) {
            return view('auth.login');
        } else {
            return redirect('admin/dashboard');
        }
    },
])->where('path', 'admin/login|login|admin');

Route::post('postLogin', [AuthController::class, 'postLogin']);
Route::get('logout', [AuthController::class, 'logout']);

Route::middleware([checkAdminRole::class])
    ->prefix('admin')
    ->group(function () {
        Route::get('dashboard', [StationController::class, 'headerView']);
        Route::get('station/list', [StationController::class, 'list']);
        Route::post('station/getList', [StationController::class, 'getList']);

        Route::get('station/add', [StationController::class, 'add']);
        Route::get('station/update', [StationController::class, 'add']);
        Route::post('station/addlist', [StationController::class, 'addlist']);
        Route::post('station/save', [StationController::class, 'save']);
        Route::post('station/request/delete', [StationController::class, 'delete']);
        
});
