<?php $__env->startSection('title', 'Location : Add New'); ?>
<?php $__env->startSection('content'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo asset('plugin/datetimepicker/jquery.datetimepicker.css'); ?>">
    <style>
        .image-preview img {
            width: 100%;
            height: 309px;
            object-fit: contain;
        }

        .image-preview {
            height: 309px;
            width: 100%;
        }

        .dragging {
            border: 2px dashed #999;
            background: #f0f0f0;
        }
    </style>
    <div class="middle-part-wrap location-add-page-wrap">
        <form id="addForm" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="id" id="id"
                value="<?php echo e(!empty($details) && !empty($details->id) ? $details->id : ''); ?>">
            <div class="add-new-service">
                <div class="leadership-top-header">
                    <h3><?php echo e(!empty($details) && !empty($details->id) ? 'Updating' : 'Adding'); ?> Location</h3>                    
                </div>
                <div class="add-new-service-wrap location-wrap">
                    <div class="scroll">
                        <div class="add-new-service-detail">
                            <div class="add-new-service-detail-top">
                                <div class="add-new-service-detail-top-right">
                                    <h4>Locations </h4>
                                    <div class="add-new-service-detail-bottom-box mb-10">
                                        <div class="form-group">
                                            <input type="text" id="title" name="title" class="form-control required" placeholder="Location Title here." maxlength="250" value="<?php echo e(@$details->title); ?>">
                                        </div>
                                    </div>
                                    <div class="add-new-service-detail-bottom-box mb-10">
                                        <div class="form-group">
                                            <input type="text" id="mapLink" name="mapLink" class="form-control required url" placeholder="Location Link" maxlength="250" value="<?php echo e(@$details->mapLink); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <textarea class="form-control required" id="address" name="address" placeholder="Add Address" maxlength="500"><?php echo e(!empty($details) && !empty($details->address) ? $details->address : ''); ?></textarea>
                                    </div>
                                </div>
                                <div class="add-new-service-detail-top-left">
                                    <h4>Location Image</h4>
                                    <?php
                                        $imageVisible = !empty($details) && !empty($details->image) ? '' : 'none';
                                    ?>
                                    <div class="uploader-wrap" id="image-upload" data-type="image">
                                        <div class="uploader-button">
                                            <a href="javascript:void(0);" class="file-input" data-type="image">
                                                <img src="<?php echo e(asset('images/image-icon.png')); ?>"
                                                    style="display:<?php echo e(!empty($details) && !empty($details->image) ? 'none' : ''); ?>;">
                                            </a>
                                            <input type="file" id="image-file" name="image" accept="image/*"
                                                data-value="<?php echo e(!empty($details) && !empty($details->image) ? $details->image : ''); ?>"
                                                style="display:none;">
                                        </div>
                                        <div class="uploader-text"
                                            style="display:<?php echo e(!empty($details) && !empty($details->image) ? 'none' : ''); ?>;">
                                            <p>Upload PNG or JPEG image (under <?php echo e(config('app.imageMaxSize')); ?>MB).</p>
                                        </div>
                                        <div class="close-upload-item">
                                            <a href="javascript:void(0);" class="remove-image"
                                                style="display:<?php echo e($imageVisible); ?>;"><img
                                                    src="<?php echo e(asset('images/close.png')); ?>"></a>
                                        </div>
                                        <div class="image-preview" style="display:<?php echo e($imageVisible); ?>;">
                                            <img <?php if(!empty($details) && !empty($details->image)): ?> src="<?php echo e(getMedia($details->image)); ?>" <?php endif; ?>
                                                id="image-preview">
                                        </div>
                                    </div>
                                </div>
                                
                            </div>                            
                        </div>
                    </div>
                    <div class="submit-button">
                        <button type="submit"
                            class="submit-btn"><?php echo e(!empty($details) && !empty($details->id) ? 'Update' : 'Add'); ?>

                            NOW</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <script type="text/javascript" src="<?php echo asset('plugin/datetimepicker/jquery.datetimepicker.full.js'); ?>"></script>
    <script>
        var type = $('#type').val();
        var imageElement = $('#image-file');
        var imageFile = null;
        var originalFileName = null;
        var errorMessage = '';
        var isFileValid = false;
        var fileType = 'image';
        $('.locationdate').datetimepicker({
            timepicker: false,
            format: 'm/d/Y',
            maxDate: new Date(),
            scrollMonth: false,
            scrollInput: false
        });

        $(document).ready(function() {
            var currentUrl = window.location.pathname.replace("/", "");            
            if (currentUrl.includes("/location")) {                
                $('#locationLi').addClass("active");
            }
            $('input[type=text]').addClass('removeSameValueAndSpace').addClass('required');
            $('textarea').addClass('removeSameValueAndSpace').addClass('required');
            $('#addForm').validate({
                rules: {
                    title: {
                        required: true
                    },
                    mapLink: {
                        required: true
                    },
                    address: {
                        required: true
                    },
                },
                messages: {
                    title: {
                        required: "Please enter location title."
                    },
                    mapLink: {
                        required: "Please enter maplink."
                    },
                    address: {
                        required: "Please enter address."
                    },
                },
                submitHandler: function(form) {
                    submitLocationDetails();
                }
            });

            $(document).on('click', '.file-input', function(event) {
                event.stopPropagation();
                const type = $(this).data('type');
                $(`#${type}-file`).val(''); // Reset the file input value
                $(`#${type}-file`).click();
            });

            $(document).on('change', 'input[type="file"]', function(event) {
                event.stopPropagation();
                const type = $(this).attr('id').split('-')[0];
                handleFileUpload(event, type, `${type}-preview`);
            });


            function handleFileUpload(event, type, previewElement) {
                var file = event.target.files[0];
                if (!file) return;
                var fileName = file.name.replace(/\s/g, "_");
                var validationResult = {
                    isFileValid: false,
                    errorMessage: ''
                };
                if (type === 'image') {
                    validationResult = validateImageFile(file);
                }
                if (validationResult.isFileValid) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (type === 'image') {
                            $(`.${previewElement}`).show();
                            $(`.file-input`).closest(`[data-type="${type}"]`).parent().css('display', 'none');
                            $(`.file-input`).closest(`[data-type="${type}"]`).parent().next().find('p').parent()
                                .css('display', 'none');
                            $(`.${previewElement}`).parent().find('a').show();
                            $(`#${previewElement}`).attr('src', e.target.result);
                            $(`#${type}-file`).attr('data-value', e.target.result);
                            $(`#${type}-file`).attr('data-filename', fileName);
                            $(`#${type}-file`).prop('readonly', true);
                        }
                    };
                    reader.readAsDataURL(file);
                } else {
                    displayMessageModal(validationResult.errorMessage, 'error');
                }
            }

            $(document).on('click', '.remove-image', function(event) {
                event.stopPropagation();
                const uploaderWrap = $(this).closest('.uploader-wrap');
                const fileInput = uploaderWrap.find('input[type="file"]');
                const previewElement = `${uploaderWrap.attr('data-type')}-preview`;
                $(`.${previewElement}`).hide();
                $(`#${previewElement}`).attr('src', '');
                $(fileInput).parent().show();
                $(fileInput).closest('.file-input').show();
                $(fileInput).parent().find('img').show();
                $(fileInput).parent().next().find('p').parent().show();
                $(fileInput).attr('data-value', '');
                $(fileInput).attr('data-filename', '');
                $(fileInput).prop('readonly', false);
                $(this).hide();
            });

            function validateImageFile(file) {
                const validTypes = [
                    'image/png',
                    'image/jpeg',
                    'image/jpg',
                ];
                const maxSize = imageMaxSize * 1024 * 1024;

                if (!validTypes.includes(file.type)) {
                    return {
                        isFileValid: false,
                        errorMessage: 'Invalid image format. Allowed formats are png, jpg, jpeg.'
                    };
                }

                if (file.size > maxSize) {
                    return {
                        isFileValid: false,
                        errorMessage: `Image file size exceeds ${imageMaxSize}MB.`
                    };
                }

                return {
                    isFileValid: true,
                    errorMessage: ''
                };
            }

            $(document).on('dragover', '.uploader-wrap', function(event) {
                event.preventDefault();
                event.stopPropagation();
                $(this).addClass('dragging');
            });

            $(document).on('dragleave', '.uploader-wrap', function(event) {
                event.preventDefault();
                event.stopPropagation();
                $(this).removeClass('dragging');
            });

            $(document).on('drop', '.uploader-wrap', function(event) {
                event.preventDefault();
                event.stopPropagation();
                $(this).removeClass('dragging');
                const files = event.originalEvent.dataTransfer.files;
                if (files.length) {
                    const file = files[0];
                    const type = $(this).data('type');
                    const mockEvent = {
                        target: {
                            files: [file]
                        }
                    };
                    handleFileUpload(mockEvent, type, `${type}-preview`);
                }
            });
        });


        function submitLocationDetails() {
            event.preventDefault();
            var isValid = true;
            imageFile = imageElement.attr('data-value');
            if (fileType == 'image') {
                if (imageFile == '' || imageFile == undefined) {
                    displayMessageModal('Please upload valid image file.', 'error');
                    isValid = false;
                    return;
                }
            }
            if (isValid) {
                var url = "<?php echo e(url('admin/location/saveLocationDetails')); ?>";
                var formData = new FormData($('#addForm')[0]);
                $('body').prepend('<div class="loader"></div>');
                if (imageFile) {
                    originalFileName = imageElement.attr('data-filename');
                    formData.append('originalFileName', originalFileName);
                    formData.append('image', imageFile);
                }
                $('button[type="submit"]').attr('disabled', 'disabled').css('cursor', 'not-allowed');
                $.ajax({
                    url: url,
                    type: "POST",
                    cache: false,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    data: formData,
                    success: function(response) {
                        $('.loader').remove();
                        $('button[type="submit"]').removeAttr('disabled').css('cursor', 'pointer');
                        displayMessageModal(response.message, 'success', 'admin/locations');
                    },
                    error: function(error) {
                        $('.loader').remove();
                        $('button[type="submit"]').removeAttr('disabled').css('cursor', 'pointer');
                        displayMessageModal(error.responseJSON.message, 'error');
                    }
                });
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/anser-backend/resources/views/location/add.blade.php ENDPATH**/ ?>