<?php $__env->startSection('title'); ?> Contracting : <?php echo e(!empty($serviceDetails) && !empty($serviceDetails->id) ? 'Updating' : 'Adding'); ?>

Contract Vehicles <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="middle-part-wrap">
        <div class="add-contract-vehicle-wrap">
            <div class="top-title">
                <h3><?php echo e(!empty($serviceDetails) && !empty($serviceDetails->id) ? 'Updating' : 'Adding'); ?> Contract Vehicle
                </h3>
            </div>
            <form id="addVehicleServiceForm" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" id="id"
                    value="<?php echo e(!empty($serviceDetails) && !empty($serviceDetails->id) ? $serviceDetails->id : ''); ?>">
                <div class="add-contract-vehicle-detail-form">
                    <div class="scroll">
                        <div class="add-contract-title">
                            <h5>Contract Title</h5>
                            <div class="form-group">
                                <textarea class="form-control" name="title" id="title" placeholder="Enter contract title."><?php echo e(!empty($serviceDetails) && !empty($serviceDetails->title) ? $serviceDetails->title : ''); ?></textarea>
                            </div>
                        </div>
                        <div class="add-contract-description">
                            <h5>Contract Description </h5>
                            <div class="form-group">
                                <textarea class="form-control" name="description" id="description" placeholder="Enter contract description."><?php echo e(!empty($serviceDetails) && !empty($serviceDetails->description) ? $serviceDetails->description : ''); ?></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="submit-button">
                        <button type="submit"
                            class="submit-btn"><?php echo e(!empty($serviceDetails) && !empty($serviceDetails->id) ? 'Update' : 'Add'); ?>

                            NOW</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script>
        var currentUrl = window.location.pathname.replace("/", "");
        $(document).ready(function() {            
            activeLi('contracting');
            $('textarea').addClass('removeSameValueAndSpace');
            if (currentUrl.includes("vehicles") && (currentUrl.includes("add") || currentUrl.includes("edit"))) {
                $('#contractVehicles').addClass("active");
            }
            $('#addVehicleServiceForm').validate({
                rules: {
                    title: {
                        required: true
                    }
                },
                messages: {
                    title: {
                        required: "Please enter title."
                    }
                },
                submitHandler: function(form) {
                    submitServiceForm();
                }
            });
        });


        function submitServiceForm() {
            $('body').prepend('<div class="loader"></div>');
            var url = "<?php echo e(url('admin/contracting/saveContractServices')); ?>";
            var formData = new FormData($('#addVehicleServiceForm')[0]);
            $('button[type="submit"]').attr('disabled', 'disabled').css('cursor', 'not-allowed');
            $.ajax({
                url: url,
                type: "POST",
                cache: false,
                contentType: false,
                processData: false,
                dataType: "json",
                data: formData,
                success: function(response) {
                    $('.loader').remove();
                    $('button[type="submit"]').removeAttr('disabled').css('cursor', 'pointer');
                    displayMessageModal(response.message, 'success', 'admin/contracting/vehicles/list');
                },
                error: function(error) {
                    $('.loader').remove();
                    $('button[type="submit"]').removeAttr('disabled').css('cursor', 'pointer');
                    displayMessageModal(error.responseJSON.message, 'error');
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/anser-backend/resources/views/contracting/contracting-vehicles/add.blade.php ENDPATH**/ ?>