<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <title>Anser</title>
    <link rel="icon" href="images/logo.png" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" type="text/css" media="screen" href="<?php echo asset('css/bootstrap.min.css'); ?>">
    <link rel="stylesheet" type="text/css" media="screen" href="<?php echo asset('css/login.css'); ?>">
    <style>
        label.error {
            color: #dc3545 !important;
        }

        .loader {
            position: fixed;
            left: 0px;
            top: 0px;
            width: 100%;
            height: 100%;
            z-index: 9999;
            background: url('<?php echo e(asset('loader.gif')); ?>') 50% 50% no-repeat rgb(249, 249, 249);
            opacity: 0.5 !important;
        }
    </style>
    <script type="text/javascript" src="<?php echo asset('js/jquery.min.js'); ?>"></script>
</head>

<body>
    <header>
        <div class="top-header abcxyz header-wrap">
            <div class="logo">
                <a href="<?php echo e(config('app.WEB_URL')); ?>" target="_blank"><img src="images/white-logo.png"></a>
            </div>
            <div class="menu">
                <nav class="navbar navbar-expand-lg">
                    <div class="container-fluid">
                        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation"><span class="navbar-toggler-icon"></span></button>
                        <div class="collapse navbar-collapse" id="navbarSupportedContent">
                            <ul class="navbar-nav">
                                <li class="dropdown"><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>#whatwedo" class="whatwedo">What we do</a></li>
                                <li class="dropdown">
                                    <a href="javascript:void(0);" class="dropdown-toggle" data-bs-toggle="dropdown">ABOUT US</a>
                                    <ul class="dropdown-menu">
                                        <li><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>about/our-purpose" class="dropdown-item xxx">Our purpose</a></li>
                                        <li><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>about/our-impact" class="dropdown-item">our impact</a></li>
                                        <li><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>about/leadership" class="dropdown-item">Leadership</a></li>
                                        <li><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>about/directors" class="dropdown-item">Board Of Directors</a></li>
                                    </ul>
                                </li>
                                <li class="dropdown">
                                    <a href="javascript:void(0);" class="dropdown-toggle" data-bs-toggle="dropdown">Contracting</a>
                                    <ul class="dropdown-menu">
                                        <li><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>contracting/contract-vehicles" class="dropdown-item">CONTRACT VEHICLES</a></li>
                                        <li><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>contracting/business-partners" class="dropdown-item">BUSINESS PARTNERS</a></li>
                                    </ul>
                                </li>
                                <li class="dropdown"><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>careers" class="" aria-current="page">CAREERS</a></li>
                                <li class="for-employee"><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>employee" class="">For Employees</a></li>
                            </ul>
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </header>
    <div class="login-banner-wrap">
        <div class="login-banner-detail">
            <div class="banner-wrap">
                <img src="images/home-banner-new.jpg">
            </div>
            <div class="login-form-data">
                <div class="banner-logo">
                    <img src="images/banner-logo.png">
                </div>
                <div class="login-baner-text">
                    <!-- <p>Platform for delivering digital training simulations and<br> interactive solutions anytime,
                        anywhere.</p> -->
                </div>
                <div class="login-form">
                    <div class="forgot-pass-wrap">
                        <p class="alert-danger text-danger" style="text-transform:none !important;display:none;"></p>
                        <p class="alert-success text-success" style="text-transform:none !important;display:none;"></p>
                    </div>
                    <main class="form-signin">
                        <div class="forgotPasswordForm" id="forgotPasswordDiv">
                            <!-- <h5 style="color:#EDEDED;">Please enter email address you'd like your password reset information sent to</h5> -->
                            <div class="forgot-form">
                                <form class="from_wrapp" id="forgotPasswordForm" method="post">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <input type="email" id="email"
                                            class="form-control removeSameValueAndSpace required" placeholder="Enter Email"
                                            name="email">
                                    </div>
                                    <button class="login-btn forgot-btn" type="submit" id="codeNextStep">Submit</button>
                                </form>
                            </div>
                            <br>
                            <div class="login-baner-text" onclick="redirectLogin()">
                                <p style="color:#EDEDED !important;cursor: pointer;">Back to login</p>
                            </div>
                        </div>

                        <div style="display: none;" id="verifyCodeDiv">
                            <h5 style="color:#EDEDED;" id="verificationCodeHtml">Verification Code</h5>
                            <h6 style="display:none;" class="otpMessage"></h6>
                            <div class="verify-otp">
                                <form id="verifyCodeForm" class="from_wrapp">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <input type="hidden" name="otp_token" id="otp_token">
                                        <input type="text"
                                            class="form-control removeSameValueAndSpace onlyNumeric required" minlength="6"
                                            maxlength="6" id="otpInput" placeholder="Enter OTP" name="otp">
                                    </div>
                                    <div class="otp-btn">
                                        <button type="submit" class="login-btn" id="passwordNextStep">Next</button>
                                        <button type="button" class="login-btn cancel-btn" id="cancelOtp"
                                        onclick="window.location.href = '<?php echo e(url('forgot-password')); ?>'">Cancel</button>
                                    </div>

                                </form>
                            </div>
                            <br>
                            <div class="login-baner-text" id="timerDiv"
                                style="color:#EDEDED !important;cursor: pointer;">
                                <p id="timeRemaining">Time Remaining 03:00</p>
                                <p class="formchangelogin resentdotp" id="resendOtpSection" style="display:none;" onclick="resendOtp()" >
                                    Didn't receive the OTP?&nbsp;<span class="resendotp" id="resendOtp">Resend
                                        OTP</span>
                                </p>
                            </div>

                            <form id="deletePreviousOTP">
                                <?php echo csrf_field(); ?>
                            </form>
                        </div>
                        <div style="display: none;" id="resetPasswordDiv">
                            <h5 style="color:#EDEDED;">Reset Password</h5>
                            <div class="login-main">
                                <form id="resetPasswordForm" class="from_wrapp">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="forgotPasswordToken" id="forgotPasswordToken">
                                    <div class="form-group r-border">
                                        <input type="password" class="form-control removeSameValueAndSpace required"
                                            placeholder="Enter New Password" name="password">
                                    </div>
                                    <div class="form-group login-pass">
                                        <input type="password" class="form-control removeSameValueAndSpace required"
                                            placeholder="Confirm Password" name="confirmPassword">
                                    </div>
                                    <button type="submit" class="login-btn update-pass" id="updatePassword">Submit</button>
                                </form>
                            </div>
                        </div>
                        <form id="resendOTPForm">
                            <?php echo csrf_field(); ?>
                        </form>
                    </main>
                </div>
            </div>
        </div>
    </div>
    <footer>
        <div class="footer-wrap">
            <div>
                <div class="footer-section">
                    <div class="footer-left">
                        <div class="menu-top">
                            <ul>
                                <li class="contact_class">
                                    <a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>contact-us">Contact Us</a>
                                </li>
                                <li class="location_class">
                                    <a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>our-location">Location</a>
                                </li>
                                <li class="news_class">
                                    <a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>news">Newsroom</a>
                                </li>
                                <li class="sustainability_class">
                                    <a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>sustainability">Sustainability</a>
                                </li>
                                <li class="policy_class">
                                    <a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>privacy-policy">Terms of Use and Privacy Policy</a>
                                </li>
                            </ul>
                        </div>
                        <div class="menu-middle">
                            <div class="footer-social-icon">
                                <ul>
                                    <li>
                                        <p>Follow Us</p>
                                    </li>
                                    <li>
                                        <a href="https://www.linkedin.com/company/analytic-services-inc-/" target="_new">
                                            <img src="images/linked-in.svg" class="footer-social-normal">
                                            <img src="images/linked-in-hover.svg" class="footer-social-hover">
                                        </a>
                                    </li>
                                    <li>
                                        <a href="https://www.facebook.com/AnalyticServicesInc/" target="_new">
                                            <img src="images/fb.svg" class="footer-social-normal">
                                            <img src="images/facebook-hover.svg" class="footer-social-hover">
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="footer-coppyright">
                            <p>Copyright © 2024 Analytic Services Inc. All Rights Reserved.</p>
                        </div>
                    </div>
                    <div class="footer-right">
                        <div class="footer-logo">
                            <a href="<?php echo e(config('app.WEB_URL')); ?>" target="_blank"><img src="images/anser-white-logo.svg"></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <script type="text/javascript" src="<?php echo e(asset('js/jquery.validate.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/bootstrap.bundle.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/custom.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            jQuery.validator.addMethod("email", function(value, element) {
                return this.optional(element) ||
                    /^([a-zA-Z0-9_.+-])+@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/.test(value);
            }, "Please enter a valid email address.");
            localStorage.removeItem('email');
        });

        function redirectLogin() {
            window.location.href = "<?php echo e(url('/')); ?>";
        }

        $('#forgotPasswordForm').validate({
            rules: {
                email: {
                    required: true,
                    email: true
                },
            },
            messages: {
                email: {
                    required: "Please enter your email",
                    email: "Please enter a valid email address"
                }
            },
            submitHandler: function(form) {
                $('.alert-success').text('').hide();
                $('.alert-danger').text('').hide();
                forgotPasswordSubmit();
            }
        });

        function forgotPasswordSubmit() {
            $('body').prepend('<div class="loader"></div>');
            document.getElementById("codeNextStep").disabled = true;
            var formData = new FormData($('#forgotPasswordForm')[0]);
            var email = $('#email').val();
            $.ajax({
                url: "<?php echo e(url('postForgotPassword')); ?>",
                type: 'POST',
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    $('.loader').remove();
                    startTimer();
                    localStorage.setItem('email', email);
                    document.getElementById("codeNextStep").disabled = false;
                    $('#forgotPasswordDiv').remove();
                    $("input[name=otp_token]").val(response.token);
                    $('#verificationCodeHtml').hide();
                    $('.otpMessage').text(response.message).addClass('text-success').removeClass('text-danger')
                        .show();
                    $('#verifyCodeDiv').show();
                },
                error: function(error) {
                    $('.loader').remove();
                    $('html, body').animate({
                        scrollTop: $('body').offset().top
                    }, 300);
                    document.getElementById("codeNextStep").disabled = false;
                    $('.alert-danger').text(error.responseJSON.message).show().delay(5000).fadeOut();
                },
            });
        }

        function startTimer() {
            var timer = 180;
            var interval = setInterval(function() {
                timer--;
                var minutes = Math.floor(timer / 60);
                var seconds = timer % 60;
                if (seconds < 10) seconds = "0" + seconds;
                $('#timeRemaining').text("Time Remaining " + minutes + ":" + seconds);
                if (timer <= 0) {
                    clearInterval(interval);
                    $('#timeRemaining').hide();
                    deleteTimeoutOtpRecord();
                    $('#resendOtpSection').show();
                }
            }, 1000);
        }

        function deleteTimeoutOtpRecord() {
            $('.alert-success').text('').hide();
            $('.alert-danger').text('').hide();
            $('body').prepend('<div class="loader"></div>');
            var formData = new FormData($('#deletePreviousOTP')[0]);
            var email = localStorage.getItem('email');
            formData.append('email', email);
            $.ajax({
                url: "<?php echo e(url('deleteTimeoutOtpRecord')); ?>",
                type: 'POST',
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    $('.loader').remove();
                    $('#verificationCodeHtml').hide();
                    $('#otpInput').val('');
                    $('.otpMessage').text(response.message).removeClass('text-success').addClass('text-danger')
                        .show();
                    $('#resendOtpSection').show();
                    $('#resendOtp').show();
                    $('#resendOtp').val('');
                },
                error: function(error) {
                    $('.loader').remove();
                    $('html, body').animate({
                        scrollTop: $('body').offset().top
                    }, 300);
                    document.getElementById("codeNextStep").disabled = false;
                    $('.alert-danger').text(error.responseJSON.message).show().delay(5000).fadeOut();
                },
            });
        }


        $('#verifyCodeForm').validate({
            rules: {
                otp: {
                    required: true,
                    digits: true,
                    minlength: 6,
                    maxlength: 6
                }
            },
            messages: {
                otp: {
                    required: "Please enter the OTP",
                    digits: "The OTP should only contain digits",
                    minlength: "The OTP should be 6 digits long",
                    maxlength: "The OTP should be 6 digits long"
                }
            },
            submitHandler: function(form) {
                $('.alert-success').text('').hide();
                $('.alert-danger').text('').hide();
                forgotPasswordVerifyOtp();
            }
        });


        function forgotPasswordVerifyOtp() {
            $('body').prepend('<div class="loader"></div>');
            document.getElementById("passwordNextStep").disabled = true;
            var formData = new FormData($('#verifyCodeForm')[0]);
            var email = localStorage.getItem('email');
            formData.append('email', email);
            $.ajax({
                url: "<?php echo e(url('forgotPasswordVerifyOtp')); ?>",
                type: 'POST',
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    $('.loader').remove();
                    document.getElementById("passwordNextStep").disabled = false;
                    $('#verifyCodeDiv').remove();
                    $("input[name=forgotPasswordToken]").val(response.token);
                    $('#resetPasswordDiv').show();
                },
                error: function(error) {
                    $('.loader').remove();
                    if (error.responseJSON.isTimeOut && error.responseJSON.isTimeOut == 1) {
                        location.reload(true);
                    } else {
                        $('html, body').animate({
                            scrollTop: $('body').offset().top
                        }, 300);
                        $('#verificationCodeHtml').hide();
                        document.getElementById("passwordNextStep").disabled = false;
                        $('.otpMessage').text(error.responseJSON.message).removeClass(
                            'text-success').addClass(
                            'text-danger').show();
                    }
                },
            });
        }

        $('#resetPasswordForm').validate({
            rules: {
                password: {
                    required: true,
                    minlength: 8
                },
                confirmPassword: {
                    required: true,
                    equalTo: "[name='password']"
                }
            },
            messages: {
                password: {
                    required: "Please enter a new password",
                    minlength: "Your new password must be at least 8 characters long"
                },
                confirmPassword: {
                    required: "Please confirm your new password",
                    equalTo: "Passwords do not match"
                }
            },
            submitHandler: function(form) {
                $('.alert-success').text('').hide();
                $('.alert-danger').text('').hide();
                updatePassword();
            }
        });


        function updatePassword() {
            $('body').prepend('<div class="loader"></div>');
            document.getElementById("updatePassword").disabled = true;
            var formData = new FormData($('#resetPasswordForm')[0]);
            var email = localStorage.getItem('email');
            formData.append('email', email);
            $.ajax({
                url: "<?php echo e(url('updatePassword')); ?>",
                type: 'POST',
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    $('.loader').remove();
                    document.getElementById("updatePassword").disabled = false;
                    window.location.href = "<?php echo e(url('/')); ?>";
                },
                error: function(error) {
                    $('.loader').remove();
                    if (error.responseJSON.isTimeOut && error.responseJSON.isTimeOut == 1) {
                        location.reload(true);
                    } else {
                        $('html, body').animate({
                            scrollTop: $('body').offset().top
                        }, 300);
                        document.getElementById("updatePassword").disabled = false;
                        $('.alert-danger').text(error.responseJSON.message).show().delay(5000).fadeOut();
                    }
                },
            });
        }

        function resendOtp() {
            $('#verificationCodeHtml').hide();
            $('#otpInput').val('');
            $('.otpMessage').text('New OTP is sending on your email address...').addClass('text-success').removeClass(
                'text-danger').show();
            $('body').prepend('<div class="loader"></div>');
            $('.alert-success').text('').hide();
            $('.alert-danger').text('').hide();
            var formData = new FormData($('#resendOTPForm')[0]);
            var email = localStorage.getItem('email');
            formData.append('email', email);
            document.getElementById("resendOtp").disabled = true;
            $('#timeRemaining').hide();
            $('#resendOtpSection').hide();
            $('#resendOtp').hide();
            $.ajax({
                url: "<?php echo e(url('resendOtp')); ?>",
                type: 'POST',
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    $('.loader').remove();
                    $("input[name=otp_token]").val(response.token);
                    $('#verificationCodeHtml').hide();
                    $('.otpMessage').text(response.message).addClass('text-success').removeClass('text-danger')
                        .show();
                    $('#timeRemaining').show();
                    startTimer();
                },
                error: function(error) {
                    $('.loader').remove();
                    if (error.responseJSON.isTimeOut && error.responseJSON.isTimeOut == 1) {
                        location.reload(true);
                    } else {
                        $('#timeRemaining').hide();
                        $('#resendOtpSection').show();
                        $('#resendOtp').show();
                        $('#resendOtp').css('cursor', 'pointer');
                        $('html, body').animate({
                            scrollTop: $('body').offset().top
                        }, 300);
                        document.getElementById("resendOtp").disabled = false;
                        $('.alert-danger').text(error.responseJSON.message).show().delay(5000)
                            .fadeOut();
                    }
                },
            });
        }

        function goToHome() {
            var formData = new FormData();
            var email = localStorage.getItem('email');
            var token = "<?php echo e(csrf_token()); ?>";
            formData.append('email', email);
            formData.append('_token', token);
            $.ajax({
                url: "<?php echo e(url('removeForgotPasswordDetails')); ?>",
                type: 'POST',
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    window.location.href = "<?php echo e(url('/')); ?>";
                },
                error: function(error) {
                    $('html, body').animate({
                        scrollTop: $('body').offset().top
                    }, 300);
                    document.getElementById("resendOtp").disabled = false;
                    $('.alert-danger').text(error.responseJSON.message).show().delay(5000)
                        .fadeOut();
                },
            });
        }
    </script>
</body>

</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/anser-backend/resources/views/auth/forgot-password.blade.php ENDPATH**/ ?>