<?php $__env->startSection('title', 'Home : Add Service'); ?>
<?php $__env->startSection('content'); ?>
    <style>
        .image-preview img {
            width: 100%;
            height: 309px;
            object-fit: contain;
        }

        .image-preview {
            height: 309px;
            width: 100%;
        }

        .dragging {
            border: 2px dashed #999;
            background: #f0f0f0;
        }
    </style>
    <div class="middle-part-wrap add-what-we-do-service-wrap">
        <input type="hidden" name="serviceImage" value="<?php echo e(!empty($serviceDetails) ? $serviceDetails->filePath : ''); ?>">
        <form id="addServiceForm" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="id" id="id"
                value="<?php echo e(!empty($serviceDetails) && !empty($serviceDetails->id) ? $serviceDetails->id : ''); ?>">
            <div class="add-new-service">
                <div class="top-title">
                    <h3>
                        <?php if(!empty($serviceDetails)): ?>
                            Updating
                        <?php else: ?>
                            Adding New
                        <?php endif; ?>
                        Service
                    </h3>
                </div>
                <div class="add-new-service-wrap">
                    <div class="scroll">
                        <div class="add-new-service-detail">
                            <div class="add-new-service-detail-top">
                                <div class="add-new-service-detail-top-left">
                                    <h4>Service Image</h4>
                                    <?php
                                    $imageVisible = !empty($serviceDetails) && !empty($serviceDetails->filePath) ? '' : 'none';
                                    ?>
                                    <div class="uploader-wrap" id="image-upload" data-type="image">
                                        <div class="uploader-button">
                                            <a href="javascript:void(0);" class="file-input" data-type="image">
                                                <img src="<?php echo e(asset('images/image-icon.png')); ?>"
                                                    style="display:<?php echo e(!empty($serviceDetails) && !empty($serviceDetails->filePath) ? 'none' : ''); ?>;">
                                            </a>
                                            <input type="file" id="image-file" name="image" accept="image/*"
                                                data-value="<?php echo e(!empty($serviceDetails) && !empty($serviceDetails->filePath) ? $serviceDetails->filePath : ''); ?>"
                                                style="display:none;">
                                        </div>
                                        <div class="uploader-text"
                                            style="display:<?php echo e(!empty($serviceDetails) && !empty($serviceDetails->filePath) ? 'none' : ''); ?>;">
                                            <p>Upload PNG or JPEG image (under <?php echo e(config('app.imageMaxSize')); ?>MB).</p>
                                        </div>
                                        <div class="close-upload-item">
                                            <a href="javascript:void(0);" class="remove-image"
                                                style="display:<?php echo e($imageVisible); ?>;"><img
                                                    src="<?php echo e(asset('images/close.png')); ?>"></a>
                                        </div>
                                        <div class="image-preview" style="display:<?php echo e($imageVisible); ?>;">
                                            <img <?php if(!empty($serviceDetails) && !empty($serviceDetails->filePath)): ?> src="<?php echo e(getMedia($serviceDetails->filePath)); ?>" <?php endif; ?>
                                                id="image-preview">
                                        </div>
                                    </div>
                                </div>
                                <div class="add-new-service-detail-top-right">
                                    <h4>Capabilities</h4>
                                    <div class="form-group">
                                        <textarea class="form-control" placeholder="Add capability" name="capabilities"><?php echo e(!empty($serviceDetails) && !empty($serviceDetails->capabilities) ? $serviceDetails->capabilities : ''); ?></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="add-new-service-detail-bottom">
                                <div class="add-new-service-detail-bottom-box">
                                    <h4>Title</h4>
                                    <div class="form-group">
                                        <input class="form-control" placeholder="Enter Service Title" name="title" type="text" value="<?php echo e(@$serviceDetails->title); ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="add-new-service-detail-bottom">
                                <div class="add-new-service-detail-bottom-box">
                                    <h4>Overview</h4>
                                    <div class="form-group">
                                        <textarea class="form-control" placeholder="Enter Service Overview" name="overview"><?php echo e(!empty($serviceDetails) && !empty($serviceDetails->overview) ? $serviceDetails->overview : ''); ?></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="submit-button">
                        <button type="submit" class="submit-btn"><?php echo e(!empty($serviceDetails) && !empty($serviceDetails->id) ? 'Update' : 'Add'); ?> Now</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <script>
        $(document).ready(function() {
            activeLi('home');
            $('textarea').addClass('removeSameValueAndSpace');
            $('input[type=text]').addClass('removeSameValueAndSpace').addClass('required');

            if (currentUrl.includes("service")) {
                $('#whatwedo').addClass("active");
            }
            $('#addServiceForm').validate({
                rules: {                    
                    title: {
                        required: true
                    },
                    overview: {
                        required:true
                    }
                },
                messages: {
                    title: {
                        required: "Please enter a title."
                    },
                    overview: {
                        required: "Please enter overview."
                    }
                },
                submitHandler: function(form) {
                    headerSubmit();
                }
            });
            $(document).on('click', '.file-input', function(event) {
                event.stopPropagation();
                const type = $(this).data('type');
                $(`#${type}-file`).val('');
                $(`#${type}-file`).click();
            });

            $(document).on('change', 'input[type="file"]', function(event) {
                event.stopPropagation();
                const type = $(this).attr('id').split('-')[0];
                handleFileUpload(event, type, `${type}-preview`);
            });
        });
        function handleFileUpload(event, type, previewElement) {
            var file = event.target.files[0];
            if (!file) return;
            var fileName = file.name.replace(/\s/g, "_");
            var valid = false;
            var errorMessage = '';

            if (type === 'image') {
                valid = validateImageFile(file);
                if (!valid) {
                    errorMessage = `Invalid image file. Please ensure it is under ${imageMaxSize}MB and of valid format.`;
                }
            }
            if (valid) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    if (type === 'image') {
                        $("input[name=serviceImage]").val(e.target.result);
                        $(`.${previewElement}`).show();
                        $(`.file-input`).closest(`[data-type="${type}"]`).parent().css('display', 'none');
                        $(`.file-input`).closest(`[data-type="${type}"]`).parent().next().find('p').parent()
                            .css('display', 'none');
                        $(`.${previewElement}`).parent().find('a').show();
                        $(`#${previewElement}`).attr('src', e.target.result);
                        $(`#${type}-file`).attr('data-value', e.target.result);
                        $(`#${type}-file`).attr('data-filename', fileName);
                        $(`#${type}-file`).prop('readonly', true);
                    }
                };
                reader.readAsDataURL(file);
            } else {
                displayMessageModal(errorMessage, 'error');
            }
        }
        function validateImageFile(file) {
            const validTypes = ['image/png', 'image/jpeg', 'image/gif'];
            const maxSize = imageMaxSize * 1024 * 1024;
            return validTypes.includes(file.type) && file.size <= maxSize;
        }
        function headerSubmit() {
            if (!$("input[name=serviceImage]").val()) {
                displayMessageModal('Please upload valid image file.', 'error');
                return false;
            }
            var formData = new FormData($('#addServiceForm')[0]);
            $('body').prepend('<div class="loader"></div>');
            $.ajax({
                url: "<?php echo e(url('admin/saveServiceDetails')); ?>",
                type: "POST",
                cache: false,
                contentType: false,
                processData: false,
                dataType: "json",
                data: formData,
                success: function(response) {
                    $('.loader').remove();
                    $('button[type="submit"]').removeAttr('disabled').css('cursor', 'pointer');
                    displayMessageModal(response.message, 'success', 'admin/home/whatwedo');
                },
                error: function(error) {
                    $('.loader').remove();
                    $('button[type="submit"]').removeAttr('disabled').css('cursor', 'pointer');
                    displayMessageModal(error.responseJSON.message, 'error');
                }
            });
        }
        $(document).on('click', '.remove-image', function(event) {
            event.stopPropagation();
            const uploaderWrap = $(this).closest('.uploader-wrap');
            const fileInput = uploaderWrap.find('input[type="file"]');
            const previewElement = `${uploaderWrap.attr('data-type')}-preview`;
            $(`.${previewElement}`).hide();
            $(`#${previewElement}`).attr('src', '');
            $(fileInput).parent().show();
            $(fileInput).closest('.file-input').show();
            $(fileInput).parent().find('img').show();
            $(fileInput).parent().next().find('p').parent().show();
            $(fileInput).attr('data-value', '');
            $(fileInput).attr('data-filename', '');
            $(fileInput).prop('readonly', false);
            $(this).hide();
            $("input[name=serviceImage]").val('');
            $('#image-file').val('');
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/anser-backend/resources/views/home/addservice.blade.php ENDPATH**/ ?>