<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <title>Anser</title>
    <link rel="icon" href="images/logo.png" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" type="text/css" media="screen" href="<?php echo asset('css/bootstrap.min.css'); ?>">
    <link rel="stylesheet" type="text/css" media="screen" href="<?php echo asset('css/login.css'); ?>">
    <style>
        label.error {
            color: #dc3545 !important;
        }

        .loader {
            position: fixed;
            left: 0px;
            top: 0px;
            width: 100%;
            height: 100%;
            z-index: 9999;
            background: url('<?php echo e(asset('loader.gif')); ?>') 50% 50% no-repeat rgb(249, 249, 249);
            opacity: 0.5 !important;
        }
    </style>
    <script type="text/javascript" src="<?php echo asset('js/jquery.min.js'); ?>"></script>
</head>

<body>
    <header>
        <div class="top-header abcxyz header-wrap">
            <div class="logo">
                <a href="<?php echo e(config('app.WEB_URL')); ?>" target="_blank"><img src="images/anser-new-logo.svg"></a>
            </div>
            <div class="menu">
                <nav class="navbar navbar-expand-lg">
                    <div class="container-fluid">
                        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation"><span class="navbar-toggler-icon"></span></button>
                        <div class="collapse navbar-collapse" id="navbarSupportedContent">
                            <ul class="navbar-nav">
                                <li class="dropdown"><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>#whatwedo" class="whatwedo">What we do</a></li>
                                <li class="dropdown">
                                    <a href="javascript:void(0);" class="dropdown-toggle" data-bs-toggle="dropdown">ABOUT US</a>
                                    <ul class="dropdown-menu">
                                        <li><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>about/our-purpose" class="dropdown-item xxx">Our purpose</a></li>
                                        <li><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>about/our-impact" class="dropdown-item">our impact</a></li>
                                        <li><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>about/leadership" class="dropdown-item">Leadership</a></li>
                                        <li><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>about/directors" class="dropdown-item">Board Of Directors</a></li>
                                    </ul>
                                </li>
                                <li class="dropdown">
                                    <a href="javascript:void(0);" class="dropdown-toggle" data-bs-toggle="dropdown">Contracting</a>
                                    <ul class="dropdown-menu">
                                        <li><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>contracting/contract-vehicles" class="dropdown-item">CONTRACT VEHICLES</a></li>
                                        <li><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>contracting/business-partners" class="dropdown-item">BUSINESS PARTNERS</a></li>
                                    </ul>
                                </li>
                                <li class="dropdown"><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>careers" class="" aria-current="page">CAREERS</a></li>
                                <li class="for-employee"><a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>employee" class="">For Employees</a></li>
                            </ul>
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </header>
    <div class="login-banner-wrap">
        <div class="login-banner-detail">
            <div class="banner-wrap">
                <img src="images/home-banner-1.jpg">
            </div>
            <div class="login-form-data">
                <div class="banner-logo">
                    <img src="images/anser-new-logo.svg">
                </div>
                <!-- <div class="login-baner-text">
                    <p>Platform for delivering digital training simulations and<br> interactive solutions anytime,
                        anywhere.</p>
                </div> -->
                <div class="login-form">
                    <div class="forgot-pass-wrap">
                        <?php if(Session::has('failure')): ?>
                            <p class="alert-danger text-danger"><?php echo e(Session::get('failure')); ?></p>
                        <?php endif; ?>
                        <?php if(Session::has('success')): ?>
                            <p class="alert-success text-success"><?php echo e(Session::get('success')); ?></p>
                        <?php endif; ?>
                        <p class="alert-danger text-danger" style="display:none;"></p>
                    </div>
                    <main class="form-signin">
                        <div>
                            <div class="login-main">
                                <form class="from_wrapp" id="loginForm" method="post">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group r-border">
                                        <input type="email" class="form-control removeSameValueAndSpace required"
                                            placeholder="Enter Email" name="email">
                                    </div>
                                    <div class="form-group login-pass">
                                        <input type="password" class="form-control removeSameValueAndSpace required"
                                            placeholder="Enter Password" name="password">
                                    </div>
                                    <button class="login-btn login-page" type="submit">Log in</button>
                                </form>
                            </div>
                            <br>
                            <div class="login-baner-text" onclick="redirectForgotPassword()">
                                <p style="color:#EDEDED !important;cursor: pointer;">Forgot password? Reset here</p>
                            </div>
                        </div>
                    </main>
                </div>
                <div class="banner-caption-bottom">
                    <div class="banner-text"><div class=""><h1>Where Purpose Drives Results</h1></div></div>
                </div>
            </div>
        </div>
    </div>
    <footer>
        <div class="footer-wrap">
            <div>
                <div class="footer-section">
                    <div class="footer-left">
                        <div class="menu-top">
                            <ul>
                                <li class="contact_class">
                                    <a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>contact-us">Contact Us</a>
                                </li>
                                <li class="location_class">
                                    <a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>our-location">Location</a>
                                </li>
                                <li class="news_class">
                                    <a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>news">Newsroom</a>
                                </li>
                                <li class="sustainability_class">
                                    <a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>sustainability">Sustainability</a>
                                </li>
                                <li class="policy_class">
                                    <a target="_blank" href="<?php echo e(config('app.WEB_URL')); ?>privacy-policy">Terms of Use and Privacy Policy</a>
                                </li>
                            </ul>
                        </div>
                        <div class="menu-middle">
                            <div class="footer-social-icon">
                                <ul>
                                    <li>
                                        <p>Follow Us</p>
                                    </li>
                                    <li>
                                        <a href="https://www.linkedin.com/company/analytic-services-inc-/" target="_new">
                                            <img src="images/linked-in.svg" class="footer-social-normal">
                                            <img src="images/linked-in-hover.svg" class="footer-social-hover">
                                        </a>
                                    </li>
                                    <li>
                                        <a href="https://www.facebook.com/AnalyticServicesInc/" target="_new">
                                            <img src="images/fb.svg" class="footer-social-normal">
                                            <img src="images/facebook-hover.svg" class="footer-social-hover">
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="footer-coppyright">
                            <p>Copyright © 2024 Analytic Services Inc. All Rights Reserved.</p>
                        </div>
                    </div>
                    <div class="footer-right">
                        <div class="footer-logo">
                            <a href="<?php echo e(config('app.WEB_URL')); ?>" target="_blank"><img src="images/anser-white-logo.svg"></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <script type="text/javascript" src="<?php echo e(asset('js/jquery.validate.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/bootstrap.bundle.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/custom.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            $('.alert-danger').delay(5000).fadeOut();
            $('.alert-success').delay(5000).fadeOut();
            localStorage.removeItem('email');
            jQuery.validator.addMethod("email", function(value, element) {
                return this.optional(element) ||
                    /^([a-zA-Z0-9_.+-])+@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/.test(value);
            }, "Please enter a valid email address.");

            $('#loginForm').validate({
                rules: {
                    email: {
                        required: true,
                        email: true
                    },
                    password: {
                        required: true,
                        minlength: 8
                    }
                },
                messages: {
                    email: {
                        required: "Please enter your email",
                        email: "Please enter a valid email address"
                    },
                    password: {
                        required: "Please enter your password",
                        minlength: "Your password must be at least 8 characters long"
                    }
                },
                submitHandler: function(form) {
                    $('body').prepend('<div class="loader"></div>');
                    loginSubmit();
                }
            });
        });

        function loginSubmit() {
            $("button[type=submit]").attr("disabled", "disabled");
            var formData = new FormData($('#loginForm')[0]);
            $.ajax({
                url: "<?php echo e(url('postLogin')); ?>",
                type: 'POST',
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    $('.loader').remove();
                    $("button[type=submit]").removeAttr('disabled');
                    window.location.href = "<?php echo e(url('admin/home/header')); ?>";
                },
                error: function(error) {
                    $('.loader').remove();
                    $('html, body').animate({
                        scrollTop: $('body').offset().top
                    }, 300);
                    $("button[type=submit]").removeAttr('disabled');
                    $('.alert-danger').text(error.responseJSON.message).show().delay(5000).fadeOut();
                },
            });
        }

        function redirectForgotPassword() {
            window.location.href = "<?php echo e(url('forgot-password')); ?>";
        }
    </script>
</body>

</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/anser-backend/resources/views/auth/login.blade.php ENDPATH**/ ?>