<?php $__env->startSection('title', 'Anser : Terms of Use'); ?>
<?php $__env->startSection('content'); ?>
    <div class="middle-part-wrap privacy-terms-page-wrap">
        <form id="addForm" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php
                $currentUrl = url()->current();
            ?>
            <input type="hidden" name="id" id="id"
                value="<?php echo e(!empty($details) && !empty($details->id) ? $details->id : ''); ?>">
            <div class="add-new-service">
                <div class="leadership-top-header">
                    <?php if(strpos($currentUrl, "terms") !== false): ?>
                        <h3>Terms of Use</h3>
                    <?php endif; ?>
                    <?php if(strpos($currentUrl, "privacy-policy") !== false): ?>
                        <h3>Privacy Policy</h3>
                    <?php endif; ?>    
                </div>
                <div class="add-new-service-wrap location-wrap">
                    <div class="scroll">
                        <div class="add-new-service-detail sustainability-top-header">
                            <input type="hidden" name="id" id="id" value="<?php echo e(!empty($details) && !empty($details->id) ? $details->id : ''); ?>">
                            <div class="form-group" id="editor" style="min-height: 250px;">                                
                                <textarea <?php if(strpos($currentUrl, "terms") !== false): ?> data-value="<?php echo e(!empty($details) && !empty($details->terms) ? $details->terms : ''); ?>" <?php else: ?> data-value="<?php echo e(!empty($details) && !empty($details->privacy) ? $details->privacy : ''); ?>" <?php endif; ?>
                                    class="form-control required" <?php if(strpos($currentUrl, "terms") !== false): ?> placeholder="Enter Terms of Use here." <?php else: ?> placeholder="Enter Privacy Policy." <?php endif; ?> id="terms" 
                                    <?php if(strpos($currentUrl, "terms") !== false): ?> name="terms" <?php else: ?> name="privacy" <?php endif; ?>
                                    maxlength="10000"></textarea>                                
                            </div>
                        </div>
                    </div>
                    <div class="submit-button">
                        <button type="submit"
                            class="submit-btn"><?php echo e(!empty($details) && !empty($details->id) ? 'Update' : 'Add'); ?>

                            NOW</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <script type="text/javascript" src="<?php echo asset('plugin/tinyeditor/tinymce.min.js'); ?>"></script>
    <script>        
        var description = $('#terms').attr('data-value');
        $(document).ready(function() {
            $('body').prepend('<div class="loader"></div>');
            activeLi('terms_&_policy');
            var currentUrl = window.location.pathname.replace("/", "");
            if (currentUrl.includes("terms")) {
                $('#termsOfUse').addClass("active");
            }
            if (currentUrl.includes("privacy-policy")) {
                $('#privacyPolicy').addClass("active");
            }            
            tinyEditor('terms');
            $('textarea').addClass('removeSameValueAndSpace').addClass('required');
            $('#addForm').validate({                
                submitHandler: function(form) {
                    description = tinymce.get('terms').getContent();
                    if (!description || description.trim() === '') {
                        displayMessageModal("Please enter details", 'error');
                        return false;
                    }
                    submitTermsDetails();
                }
            });

            function submitTermsDetails() {
                event.preventDefault();
                var isValid = true;
                if (isValid) {
                    var url = "<?php echo e(url('admin/saveTermsDetails')); ?>";
                    var formData = new FormData($('#addForm')[0]);
                    $('body').prepend('<div class="loader"></div>');                    
                    $('button[type="submit"]').attr('disabled', 'disabled').css('cursor', 'not-allowed');
                    $.ajax({
                        url: url,
                        type: "POST",
                        cache: false,
                        contentType: false,
                        processData: false,
                        dataType: "json",
                        data: formData,
                        success: function(response) {
                            $('.loader').remove();
                            $('button[type="submit"]').removeAttr('disabled').css('cursor', 'pointer');
                            displayMessageModal(response.message, 'success', 'selfReload');
                        },
                        error: function(error) {
                            $('.loader').remove();
                            $('button[type="submit"]').removeAttr('disabled').css('cursor', 'pointer');
                            displayMessageModal(error.responseJSON.message, 'error');
                        }
                    });
                }
            }
            function validateEditorValue(selector) {
                const value = tinymce.get(`${selector}`).getContent();
                if (!value || value.trim() === "") {
                    displayMessageModal(
                        `Please enter a ${formattedSelector} copy description.`,
                        "error"
                    );
                    return false;
                }
                return true;
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/anser-backend/resources/views/terms.blade.php ENDPATH**/ ?>