<?php $__env->startSection('title', 'Home : About Us'); ?>
<?php $__env->startSection('content'); ?>
    <div class="middle-part-wrap">
        <div class="about-us-wrap">
            <div class="top-title">
                <h3>About Us (Short Description)</h3>
            </div>
            <div class="about-us-detail">
                <div class="about-us-overview">
                    <form id="aboutusFrm">
                        <?php echo csrf_field(); ?>
                        <div class="about-us-overview-box">
                            <h5>Overview</h5>
                            <div class="form-group">
                                <textarea class="form-control" placeholder="Enter Short About Us." name="aboutus_description" id="aboutus_description"><?php echo e(@$aboutUs); ?></textarea>
                            </div>
                        </div>
                        <div class="submit-button">
                            <button type="submit" class="submit-btn">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            activeLi('home');
            $('textarea').addClass('removeSameValueAndSpace');
            if (currentUrl.includes("aboutus")) {
                $('#aboutus').addClass("active");
            }
            $('#aboutusFrm').validate({
                rules: {
                    aboutus_description: {
                        required: true
                    }
                },
                messages: {
                    aboutus_description: {
                        required: "Please enter About Us short description."
                    }
                },
                submitHandler: function(form) {
                    aboutUsSubmit();
                }
            });

            function aboutUsSubmit() {                
                var url = "<?php echo e(url('admin/saveAboutus')); ?>";
                $('body').prepend('<div class="loader"></div>');
                var formData = new FormData();
                var token = "<?php echo e(csrf_token()); ?>";
                var tagline = $.trim($('#aboutus_description').val());
                formData.append('_token', token);
                formData.append('aboutus_description', tagline);
                if (tagline != undefined && tagline != '') {
                    $.ajax({
                        url: url,
                        type: "POST",
                        cache: false,
                        contentType: false,
                        processData: false,
                        dataType: "json",
                        data: formData,
                        success: function(response) {
                            $('.loader').remove();
                            displayMessageModal(response.message, 'success');
                        },
                        error: function(error) {
                            $('.loader').remove();
                            displayMessageModal(error.responseJSON.message, 'error');
                        }
                    });
                }
                $('.loader').remove();
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/anser-backend/resources/views/home/aboutus.blade.php ENDPATH**/ ?>