<?php $__env->startSection('title', 'News : List'); ?>
<?php $__env->startSection('content'); ?>
    <style>
        .image-container {
            position: relative;
        }

        .image-container img {
            display: none;
            width: 100%;
            height: auto;
        }

        .image-container .spinner-border {
            position: absolute;
            justify-content: center;
            display: block;
            left: 0;
            right: 0;
            top: 0;
            bottom: 0;
            margin: auto;
        }
    </style>
    <div class="middle-part-wrap news-list-page-wrap">
        <div class="leadership-list-wrap news-list-wrap">
            <div class="leadership-top-header">
                <h3>Newsroom</h3>                
                <a href="<?php echo e(url('admin/news/add')); ?>">Add News</a>                
            </div>
            <div class="leadership-list-data scroll">                
                <ul class="listRecordsUl">
                    <?php if(count($list) > 0): ?>
                        <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li id="record_<?php echo e($key); ?>" class="listRecordsLi">
                                <div class="leadership-list-text">
                                    <div class="leadership-bio-data">
                                        <div class="leadership-list-text-left">
                                            <div class="image-container">
                                                <div class="spinner-border text-secondary" role="status" >
                                                    <span class="sr-only"></span>
                                                  </div>
                                                <img src="<?php echo e(!empty($value->image) ? getMedia($value->image) : asset('images/user.jpg')); ?>"
                                                    alt="<?php echo e(!empty($value->title) ? $value->title : 'News Image'); ?>"
                                                    onload="this.style.display='block'; this.previousElementSibling.style.display='none';"
                                                    onerror="this.style.display='none'; this.previousElementSibling.style.display='none';">
                                            </div>
                                        </div>
                                        <div class="leadership-list-text-middle">
                                            <h5><?php echo e(!empty($value->title) ? $value->title : ''); ?></h5>
                                            <h6>Short Summary</h6>
                                            <p><?php echo !empty($value->summary) ? $value->summary : ''; ?></p>
                                            <!-- <p><?php echo \Illuminate\Support\Str::limit($value->summary, 300, $end='...'); ?></p> -->
                                        </div>
                                    </div>
                                    <div class="leadership-list-text-right">
                                        <ul>
                                            <li>
                                                <a href="javascript:void(0);" data-id="<?php echo e($value->id); ?>"
                                                    data-key="<?php echo e($key); ?>"
                                                    data-fullname="<?php echo e(!empty($value->title) ? "<b>".truncateString($value->title, 17)."</b>" : ''); ?>"
                                                    class="delete deleteRecord">Delete</a>
                                            </li>
                                            <li>
                                                <a href="<?php echo e(url("admin/news/edit/$value->pageUrl")); ?>"
                                                    class="edit">Edit</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <li>
                            <div class="alert text-center alert-warning">
                                No records found.
                            </div>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>


        </div>
    </div>

    <script>
        var currentUrl = window.location.pathname.replace("/", "");        
        $(document).on('click', '.deleteRecord', function(e) {
            e.stopPropagation();
            var $this = $(this);
            var id = $this.attr('data-id');
            var name = $this.attr('data-fullname');
            var key = $this.attr('data-key');
            $('#confirmActiveInactive').attr('data-id', id);
            $('#confirmActiveInactive').attr('data-key', key);
            $('.activeInactiveModal .modal-body').html(
                `Are you want to delete ${name ? name.toUpperCase() : ''} record?`);
            $('.activeInactiveModal').modal('show');
        });

        $(document).on('click', '.close,#cancelActiveInactive', function(e) {
            e.preventDefault();
            $('#confirmActiveInactive').attr('data-id', '');
            $('#confirmActiveInactive').attr('data-key', '');
            $('.activeInactiveModal').modal('hide');
        });

        $(document).on('click', '#confirmActiveInactive', function(e) {
            e.preventDefault();
            $('.activeInactiveModal').modal('hide');
            var $this = $(this);
            var id = $this.attr('data-id');
            var key = $this.attr('data-key');
            var url = "<?php echo e(url('admin/news/deleteNewsRecord')); ?>";
            if (id) {
                $('body').prepend('<div class="loader"></div>');
                var formData = new FormData();
                var token = "<?php echo e(csrf_token()); ?>";
                formData.append('_token', token);
                formData.append('id', id);                
                $.ajax({
                    url: url,
                    type: "POST",
                    cache: false,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    data: formData,
                    success: function(response) {
                        $('.loader').remove();
                        $('html, body').animate({
                            scrollTop: $('body').offset().top
                        }, 300);
                        $(`#record_${key}`).remove();
                        if ($('.listRecordsLi').length == 0) {
                            $('.listRecordsUl').html(`<li>
                            <div class="alert text-center alert-warning">
                                No records found.
                            </div>
                            </li>`);
                        }
                        $('.closeBtn').prop('disabled', true);
                        $('.closeBtn').hide();
                        displayMessageModal(response.message, 'success');
                        setTimeout(() => {
                            location.reload(true);
                        }, 2000);
                    },
                    error: function(error) {
                        $('.loader').remove();
                        displayMessageModal(error.responseJSON.message, 'error');
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/anser-backend/resources/views/news/list.blade.php ENDPATH**/ ?>